<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subject extends Model 
{

    protected $table = 'subjects';
    public $timestamps = true;
    protected $fillable = array('name', 'academic_year_id');

    public function teachers()
    {
        return $this->belongsToMany('App\Models\Teacher', 'teacher_subject');
    }

    public function academicYear()
    {
        return $this->belongsTo('App\Models\AcademicYear');
    }

    public function students()
    {
        return $this->belongsToMany('App\Models\Student', 'student_subject');
    }

}